<?php
class database{
	public $host = DB_HOST;
	public $user = DB_USER;
	public $pass = DB_PASS;
	public $dbname = DB_NAME;
	public $link;
	public $error;

	public function __construct(){
		$this->connectDB();
	}

	private function connectDB(){
		$this ->link = new mysqli($this ->host,$this ->user, $this ->pass , $this ->dbname);
		$this ->link->set_charset('utf8mb4');
		if($this->link->connect_errno){
			$this->error = "Connection Fail! ". $this->link->connect_error .". Check database connection details on /db/db.cnf.php . If this is a fresh installation then launch <a href='../install.php' target='_self'>installer</a>.";
			exit($this->error);
		}
	}
	public function select($query){
		$result = $this->link->query($query) or die ($this->link->error.__LINE__);
		if($result){
			return $result;
		}else{
			return false;
		}
	}
	public function create($query){
		$result = $this->link->query($query) or die ($this->link->error.__LINE__);
		if($result){
			return $result;
		}else{
			return false;
		}
	}
	public function check($query){
		$result = $this->link->query($query);
		if($result){
			return $result;
		}else{
			return false;
		}
	}
  public function insert($query){
    $insert_row = $this->link->query($query) or die ($this->link->error.__LINE__);
    if($insert_row){
      return $insert_row;
    }else{
      return false;
    }
  }
  public function update($query){
    $update_row = $this->link->query($query) or die ($this->link->error.__LINE__);
    if($update_row){
      return $update_row;
    }else{
      return false;
    }
  }
  public function delete($query){
    $delete_row = $this->link->query($query) or die ($this->link->error.__LINE__);
    if($delete_row){
      return $delete_row;
    }else{
      return false;
    }
  }


}

$db = new database;

?>