<?php
/**
* App Name:       Email Verifier PRO
* App URI:        https://emailverifierpro.app
* Version:        4.7.1
* Author:         Tuhin Bhuiyan
* Author URI:     https://tuhin.dev
**/
require_once('req.data.php');
?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta name="referrer" content="origin">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>Email Verifier Pro - Installation</title>
    <link rel='canonical' href="./<?php echo $installer; ?>">
	<link rel="stylesheet" href="./assets/vendors/styles/core.min.css">   <!-- style css -->
    <link rel="stylesheet" href="./assets/styles/theme.css">   <!-- style css -->
	<link rel="stylesheet" type="text/css" href="assets/vendors/styles/icon-font.min.css">
	<link rel="stylesheet" type="text/css" href="assets/vendors/styles/style.css">
    <script src="./assets/scripts/jquery.min.js"></script>
	<style>.port_check {
		width: 100%;
		margin: 0 auto;
		display: block;
		text-align: center;
		position: relative;
		top: 25%;
		max-width: 450px;
		box-shadow: 0px 0px 10px 1px #000000a1;
		margin-bottom: 50px;
	}
	h2 {
		font-size: 20px;
		border: 1px solid black;
		background: #000;
		color: #fff;
		padding: 15px 20px;
		margin: 0;
		border-bottom: 2px dashed white;
	}
	h3 {
		background: #000;
		color: #fff;
		padding: 15px 20px;
		font-size: 18px;
		text-align: center;
		margin: 0;
		border-top: 2px dashed #fff;
	}
	h3 > a {
		color: #c5a5ff;
	}
	code {
		background: black;
		color: #21f551;
		font-size: 16px;
		display: block;
		padding: 25px 20px;
		font-weight: bold;
		text-align: left;
	}
	</style>
</head>
<body>
<noscript>
<div class="js_stop">
		<strong>Browser Do Not support JavaScript! </strong>
		We're sorry, but 'Email Verifier Pro' doesn't work without JavaScript enabled. If you can't enable JavaScript in this browser then try a different browser which support JavaScript.
</div>
	<style>#wrapper { display:none; }</style>
 </noscript>

<div class="container">	
						 
<!-- Page Heading -->
<div class="page-header mt-4">
			<h1 class="lead font-weight-bold">Email Verifier Pro - Installation</h1>
</div>

<div class="pd-20 card-box mb-30">				

<?php if (isset($_GET['installation']) && $_GET['installation'] == 'fail') {?>
     <code class="alert alert-danger text-center mt-3" role="alert">
       Installation Failed! Please try again.
     </code>
<?php }?>
	 
              <?php
if ($action == 1) { //1st check all version and show the result?>
		  <h4 class="mb-3 text-info lead">System Check</h4>
<?php 
$ports[] = array('host'=>'smtp.gmail.com','number'=>25);
$ports[] = array('host'=>'relay.dnsexit.com','number'=>25);
$ports[] = array('host'=>'smtp.office365.com','number'=>25);
$ports[] = array('host'=>'mail.emailverifierpro.app','number'=>25);

echo'<div class="port_check">';
echo '<h2 class="lead">Your Server Port 25 Outbound Results</h2>';
echo '<code>';
foreach ($ports as $port)
{
    $connection = @fsockopen($port['host'], $port['number'], $errno, $errstr, 5); // 5 second timeout for each port.

    if (is_resource($connection))
    {
        echo '<span>' . $port['host'] . ' -> port 25 open.</span>' . "\n";

        fclose($connection);
    }

    else
    {
        echo '<span style="color:red;">' . $port['host'] . ' -> port 25 block.</span>' . "\n";
		
		
    }
}
echo '</code>';
echo'<h3 class="lead small">If any above result shows port 25 as open! <br/> Then our <a href="https://codecanyon.net/item/email-verifier-pro-bulk-email-addresses-validation-mail-sender-email-lead-management-tool/24407503" target="_blank"> email verifier pro</a> will work on your system! Read more in details from Email Verifier Pro <a href="https://emailverifierpro.app/docs/minimum-requirements/" target="_blank">documentation!</a></h3>';
echo'</div>';
?>
          <table class="versions_table">
            <tr>
              <th>Name</th>
              <th>Required Values</th>
              <th>Detected Values</th>
            </tr>
			<tr>
              <td>Mysql</td>
              <td>5.6+</td>
              <?php if (empty($mysql_error)) {?>
			  <td class="version_check_pass"><?php echo $mysql_version ?></td>
            <?php } else { ?>
              <td class="version_check_error"><?php echo $mysql_error_val ?></td>
            <?php } ?>
            </tr>
            <tr>
              <td>PHP Version</td>
              <td>7.4</td>
            <?php if ($phpversion) {?>
              <td class="version_check_pass"><?php echo $php_version ?></td>
            <?php } else { ?>
              <td class="version_check_error"><?php echo $php_version ?></td>
            <?php } ?>
            </tr>
			<tr>
              <td>PHP Curl</td>
              <td>Enable</td>
            <?php if ($php_curl) {?>
              <td class="version_check_pass">Enable</td>
            <?php } else { ?>
              <td class="version_check_error">Not Found</td>
            <?php } ?>
            </tr>
            <tr>
              <td>PHP Mail</td>
              <td>Enable</td>
              <?php if ($mail) {?>
              <td class="version_check_pass">Enable</td>
            <?php } else {
    ?>
              <td class="version_check_error">Disable</td>
            <?php
}?>
            </tr>
            <tr>
              <td>PHP Session</td>
              <td>Enable</td>
              <?php if ($session) {?>
              <td class="version_check_pass">Enable</td>
            <?php } else {
    ?>
              <td class="version_check_error">Disable</td>
            <?php
}?>
            </tr>
            <tr>
              <td>PHP Session Cookies</td>
              <td>Enable</td>
              <?php if ($session_cookie_check) {?>
              <td class="version_check_pass">Enable</td>
            <?php } else {
    ?>
              <td class="version_check_error">Disable</td>
            <?php
}?>
            </tr>
            <tr>
              <td>Browser Cookies</td>
              <td>Enable</td>
              <td class="version_check_pass" id="js_check_result">Enable</td>
            </tr>
			<tr>
              <td>Folder/File Owner Check</td>
              <td>Seems Ok</td>
             <?php if ($file_error == false) {?>
              <td class="version_check_pass">Seems Ok</td>
            <?php } else { ?>
             <td class="version_check_error">Files not owned by apache user:
				<?php foreach($file_owner_issues as $file_owner_issue){
						echo '['.$file_owner_issue.'] ';
				} ?>
			</td>
            <?php } ?>
            </tr>
          </table>
		   <?php if ($error || $error_mysql) {
    ?>
        <div class="problem_found alert alert-light" id="problem_found" role="alert">
          <?php
} else {?>
          <div class="problem_found alert alert-light" id="problem_found" style="display:none" role="alert">
      <?php }?>
          <h4 class="mb-3 text-info lead">Detected Issues</h4>
          <ul id="version_problem">
            <?php if (!$phpversion) {?>
                    <li><?php echo $php_error; ?></li>
                  <?php
}?>
                  <?php if (!empty($mysql_error)) {?>
                    <li><?php echo $mysql_error; ?></li>
                  <?php
}?>
                  <?php if (!$mail) {?>
                    <li><?php echo $mail_error; ?></li>
                  <?php
}?>
                  <?php if (!$session) {?>
                    <li><?php echo $session_error; ?></li>
                  <?php
}?>
                  <?php if (!$session_cookie_check) {?>
                    <li><?php echo $session_cookie_error; ?></li>
                  <?php
}?>
          </ul>
        </div>

		<?php if ($error) {

    // Fix detected errors.

    ?>
                  <?php
} else {?>
                    <form action="" method="post">
                      <div class="form-group row mb-0">
                        <div class="col-sm-12 col-md-12">
                          <button type="submit" name="lic_chck"  class="btn btn-primary float-right">Next</button>
                        </div>
                      </div>
                  </form>
                  <?php
}
} elseif ($action == 3) { //configuration page ?>
                <?php if ($connection) {?>
				
				<code class="alert alert-success" role="alert">
					Database connection successful.
				</code>
				
                <?php
} else {?>
				<code class="alert alert-danger" role="alert">
                     <?php echo $error_msg; ?>
				</code>
                <?php
}?>
                <?php if ($connection) {
    if ($config_std) {?>
				<code class="alert alert-success" role="alert">
					Configuration successful.
				</code>
                  <?php
} else {?>
				<code class="alert alert-danger" role="alert">
				    <?php echo $error2_msg; ?>
				</code>
				<code class="alert alert-danger" role="alert">
				      Database configuration fail.
				</code>
                  <?php
}?>
                <?php
} else {?>
				<code class="alert alert-danger" role="alert">
				      Database configuration fail. Check you settings!
				</code>
                <?php
}?>
                <?php if ($error) {?>

                  <button type="button" disabled class="btn btn-info float-right">Next</button>
                  <a style="margin-right:20px" href="<?php echo $installer; ?>" class="btn btn-light float-right">back</a>
                <?php
} else {
    ?>
                <div class="alert alert-warning">Warnning: if you continue installation then all existing data will be removed from this database.</div>
                <form action="" method="post">
					<div class="row">
						<div class="col-md-12">
						<button type="submit" name="createtb"  class="btn btn-primary float-right" onClick="javascript: return confirm('Warnning: if you continue installation then all existing data will be removed from this database.');">Next</button>
						</div>
					</div>
                </form>

                <?php
}
} elseif ($action == 4) { //user create page
    ?>
				<h4 class="mb-3 text-info lead">Account Setup</h4>
				<code class="alert alert-success" role="alert">
				     Data Tables created successfully.
				</code>
				<div class="bg-light p-4 rounded border">
                <form action="" method="post" autocomplete="off">
				    <div class="form-group row">
                      <label for="system_email" class="col-sm-2 col-form-label">System Email</label>
                      <div class="col-sm-10">
                        <input  type="email" required name="system_email" class="form-control" id="system_email" placeholder="System Email">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="first_name" class="col-sm-2 col-form-label">First name</label>
                      <div class="col-sm-10">
                        <input  type="text" required name="fname" class="form-control" id="fname" placeholder="First Name">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="last_name" class="col-sm-2 col-form-label">Last name</label>
                      <div class="col-sm-10">
                        <input  type="text" required name="lname" class="form-control" id="lname" placeholder="Last Name">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="username" class="col-sm-2 col-form-label">Username</label>
                      <div class="col-sm-10">
                        <input  type="text" required name="username" class="form-control" id="username" placeholder="Username">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="email" class="col-sm-2 col-form-label">Email</label>
                      <div class="col-sm-10">
                        <input type="email" required name="email" class="form-control" id="email" placeholder="Email">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="password" required class="col-sm-2 col-form-label">Password</label>
                      <div class="col-sm-10">
                        <input type="password" required name="pass" class="form-control" id="password" placeholder="Password">
                      </div>
                    </div>
                    <div class="form-group row mb-0">
                      <div class="col-sm-12 col-md-12">
                        <button type="submit" name="done" class="complete btn btn-primary float-right">Complete</button>
                      </div>
                    </div>
                    <div class="form-group validation_error mb-0">
                    </div>
                  </form>
				  </div>
              <?php
} elseif ($action == 2) { //configuration info page ?>
				<h4 class="mb-3 text-info lead">Database Setup</h4>
                <form class="bg-light p-4 rounded border" action="" method="post">
                  
                  <?php if (!$license_error && !empty($license_verify_msg)) {?>
                    <div class="alert bg-success text-light text-center"><?php echo $license_verify_msg; ?></div>
                  <?php }?>
                    <div class="form-group row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label">DB HOST</label>
                      <div class="col-sm-10">
                        <input type="text" required name="dbhost" class="form-control" id="inputEmail3" placeholder="db host">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label">DB USER</label>
                      <div class="col-sm-10">
                        <input type="text" required name="dbuser" class="form-control" id="inputEmail3" placeholder="db user">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label">DB PASSWORD</label>
                      <div class="col-sm-10">
                        <input type="text"  name="dbpass" class="form-control" id="inputEmail3" placeholder="db password">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label">DB NAME</label>
                      <div class="col-sm-10">
                        <input type="text" required name="dbname" class="form-control" id="inputEmail3" placeholder="db name">
                      </div>
                    </div>
                    <div class="form-group row mb-0">
                      <div class="col-sm-12 col-md-12">
                        <button type="submit" name="dbcheck" class="btn btn-primary float-right">Next</button>
                      </div>
                    </div>
                  </form>
                <?php
} elseif ($action == 6) { //configuration info page ?>
                <h4 class="mb-3 text-info lead">Verify License</h4>
                <form class="bg-light p-4 rounded border" action="" method="post">
                  <?php if ($license_error && !empty($license_error_msg)) {?>
                    <div class="alert bg-danger text-light text-center"><?php echo $license_error_msg; ?></div>
                  <?php }?>

                    <div class="form-group row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label">License code</label>
                      <div class="col-sm-10">
                        <input type="text" required name="license" class="form-control" placeholder="enter your purches/license code">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputEmail3" class="col-sm-2 col-form-label">Your email</label>
                      <div class="col-sm-10">
                        <input type="email" required name="client" class="form-control" placeholder="enter your email">
                      </div>
                    </div>
                    <div class="form-group row mb-0">
                      <div class="col-sm-12 col-md-12">
                        <button type="submit" name="configuration" class="btn btn-primary float-right">Next</button>
                      </div>
                    </div>
                  </form>
                <?php
}?>
          </div>
           

</div>
</div>
  <footer class="footer-area text-center">
    <p>Copyright @ 2024 - <a href="https://emailverifierpro.app" title="Email Verifier Pro" target="_blank">Email Verifier Pro</a> v<?php echo $script_ver;?></p>
  </footer>
  <?php if ($action == 1) {?>

  <script>
    var cookies_errror = false;
    function cookie_check(){
      function checkCookie(){
      var cookieEnabled = navigator.cookieEnabled;
        if (!cookieEnabled){
            document.cookie = "testcookie";
            cookieEnabled = document.cookie.indexOf("testcookie")!=-1;
            return false;
        }else{
          return true;
        }
      }
      // within a window load,dom ready or something like that place your:
      var check_javascript =  checkCookie();
      if(!check_javascript){
        var node = document.createElement("LI");
        var textnode = document.createTextNode("Browser blocking cookies. Make sure your browser support and accept cookies. Usually it can happen by using browser extensions like 'Cookies Disabler' or third party applications like internet security. You can also try on a different browser which allows cookies.");
        node.appendChild(textnode);
        if(document.getElementById("problem_found").style.display == 'none'){
          document.getElementById("problem_found").style.display = 'block';
        }
        document.getElementById("version_problem").appendChild(node);
        document.getElementById("js_check_result").innerHTML = "Disable";
        document.getElementById('js_check_result').style.color = 'red';
        document.getElementsByTagName("Button").disabled = true;
        cookies_errror = true;
        var button = document.querySelectorAll('Button');
        for (var i = 0; i < button.length; i++) {
                button[i].disabled = true;
        }
      }else{
        document.getElementById("js_check_result").innerHTML = "Enable";
        document.getElementById('js_check_result').style.color = 'green';
      }
    }
    window.onload = cookie_check();
  </script>
  <script src="./assets/scripts/modernizr-custom.js">
  </script>
<script>
    function cookies(){
      Modernizr.addTest('cookies', function () {
    // Quick test if browser has cookieEnabled host property
        if (navigator.cookieEnabled) return true;
        // Create cookie
        document.cookie = "cookietest=1";
        var ret = document.cookie.indexOf("cookietest=") != -1;
        // Delete cookie
        document.cookie = "cookietest=1; expires=Thu, 01-Jan-1970 00:00:01 GMT";
        return ret;
      });
    //  we could do this with less code.
    function createCookie(name,value) {
    document.cookie = name+"="+value+"; path=/";
    }
    function readCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
      var c = ca[i];
      while (c.charAt(0)==' ') c = c.substring(1,c.length);
      if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
    }
    function eraseCookie(name) {
    createCookie(name,"",-1);
    }


    var random = '' + Math.round(Math.random() * 1e8);
    createCookie('Modernizr', random);
    Modernizr.cookies = readCookie('Modernizr') == random;
    if(Modernizr.cookies){
      document.getElementById("js_check_result").innerHTML = "Enable";
      document.getElementById('js_check_result').style.color = 'green';
    }else{
      if(!cookies_errror){
        var node = document.createElement("LI");
        var textnode = document.createTextNode("Browser blocking cookies. Make sure your browser support and accept cookies. Usually it can happen by using browser extensions like 'Cookies Disabler' or third party applications like internet security. You can also try on a different browser which allows cookies.");
        node.appendChild(textnode);
        if(document.getElementById("problem_found").style.display == 'none'){
          document.getElementById("problem_found").style.display = 'block';
        }
        document.getElementById("version_problem").appendChild(node);
        document.getElementById("js_check_result").innerHTML = "Disable";
        document.getElementById('js_check_result').style.color = 'red';
        document.getElementsByTagName("Button").disabled = true;
        var button = document.querySelectorAll('Button');
        for (var i = 0; i < button.length; i++) {
                button[i].disabled = true;
        }
      }
    }
    eraseCookie('Modernizr');
    };
    window.onload = cookies();
</script>
  <?php
}

if ($action == 4) {
    ?>
<script>
  function ValidateEmail(mail)
  {
    if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(mail))
    {
      return (true)
    }else{
      return (false)
    }
  }
  $(document).ready(function(){
    $(".complete").click(function(event){
      var fname = $("#fname").val();
      var system_email = $("#system_email").val();
      var lname = $("#lname").val();
      var username = $("#username").val();
      var email = $("#email").val();
      var password = $("#password").val();
      var status = $(".validation_error");
      $( "#usernameinput" ).removeClass( "validation-error-border" );
      $( "#email" ).removeClass( "validation-error-border" );
      $( "#password" ).removeClass( "validation-error-border" );
      status.empty();
      if(!fname || !lname || !username || !email || !password){
        event.preventDefault();
        status.append("<p>please fillup all the Input</p>");
      }else{
        if(email.length >5 && email.includes("@") && email.includes(".")){
          if(!ValidateEmail(email)){
            $("#email").addClass("validation-error-border");
            event.preventDefault();
            status.append("<p>Please enter a valid email address.</p>");
          }
        }else{
          $("#email").addClass("validation-error-border");
          event.preventDefault();
          status.append("<p>Please enter a valid email address.</p>");
        }
        if (/\s/.test(password)) {
          event.preventDefault();
          $("#password").addClass("validation-error-border");
          status.append("<p>no space acceptable in password</p>");
        }else{
          if(password.length >= 6){
            if(/[^0-9a-zA-Z]/.test(password)){
              $("#password").addClass("validation-error-border");
              event.preventDefault();
              status.append("<p>Password should contain only Charecter and number!</p>");
            }else{
              if(password.length >= 20){
                $("#password").addClass("validation-error-border");
                event.preventDefault();
                status.append("<p>Password should not be atmost 20 letter!</p>");
              }
            }
          }else{
            $("#password").addClass("validation-error-border");
            event.preventDefault();
            status.append("<p>Password should be atleast 6 letter!</p>");
          }
        }
      }
    })
  })
</script>
<?php }?>
  </body>
</html>