<?php
ob_start();
$log_type = $_GET['show_log'];
$title = str_replace('_', ' ', $log_type);
$title = ucwords($title).' Log';
include '../templates/backend/members/header.php';
Session::Check_auth();
$user_id = $_SESSION['id'];
$logfile = dirname(__DIR__)."/tmp/logs/$log_type.log";
if(file_exists($logfile)) {
global $num, $last_line;
function generate_log($logfile, $num, $reverse = false){
    $file = new \SplFileObject($logfile, 'r');
    $file->seek(PHP_INT_MAX);
    $last_line = $file->key();
	if($last_line > 0) {
		$num = 100;
		if($num >= $last_line) {
			$num = $last_line;
		}
		$lines = new \LimitIterator($file, $last_line - $num, $last_line);
		$arr = iterator_to_array($lines);
		if($reverse) {
			$arr = array_reverse($arr);
		}
		return implode('<br>',$arr);
	} else {
		return 'No logs data';
	}
		/*
		if ('' === trim($line)) {
			continue;
		}
		$file = null;
		*/
}

$lines = generate_log("$logfile", $num); // return string with last # of lines

} else {
	header("Location:$a_url");
	ob_flush();
//	ob_end_clean();
	exit();
}
?>

<!-- Page Heading -->
<div class="page-header">
<div class="pull-right">
	<button type="submit" id="clear_log" name="clear_log" class="d-sm-inline-block btn btn-sm btn-primary shadow-sm clear_logs">Clear Logs</button>
</div>
<div class="row">
	<div class="col-md-6 col-sm-12">
		<div class="title">
			<h4><?php _e($title);?></h4>
		</div>
		<nav aria-label="breadcrumb" role="navigation">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><a href="index.php"><?php _e('Dashboard');?></a></li>
				<li class="breadcrumb-item active" aria-current="page"><?php _e($title);?></li>
			</ol>
		</nav>
	</div>
</div>
</div>
				<!-- Read Log start -->
				<div class="card-box mb-30">
					<div class="pd-20">
						<h4 class="text-blue h4"><?php _e('Recent Logs');?></h4>
					</div>
					<div class="pb-20">
							<div class="bg-dark py-2 px-3 ml-md-2 mr-md-2 mt-md-3 text-white rounded-lg shadow">
								<code>
									<?php
										if ( function_exists( 'generate_log' ) ) {
											echo $lines;
										} else {
											echo '';
										}
									?>
								</code>
							</div>
					</div>
				</div>
				<!-- Read Log End -->

<script>
/**
* Clean Logs
**/
$(document).ready(function() {
	$(".clear_logs").on('click', function() {
		event.preventDefault();
		var timeoutId;
		var get_log_type = "<?php echo $logfile ?>";
		
		clearTimeout(timeoutId);
		timeoutId = setTimeout(function() {
			
		$.ajax({
			url: "../functions/logger.handler.php",
			type: "POST",
			data: {
				log_path: get_log_type
			},
			dataType: "json",
			beforeSend: function(xhr) {
				// Saving Data
				$('.log_data .submission_status').html('<?php _e('Saving');?>...').fadeIn();
			},
			success: function(data) {
				var reSuccess = data.success;
				var reError = data.error;
				//console.log(reSuccess);								
				if (reSuccess) {
					//var log_path = data.log_path; // Get return data
					var saved = $(".log_data .submission_status").html(reSuccess);
							Swal.fire({
                                type: 'success',
                                title: '<?php _e('Log Cleaned');?>',
								heightAuto: false
                            }).then(function() {
                                		location.reload();
                            })
					} else {
						var saved = $(".submission_status").html(reError);
						if(!$(".log_data .submission_status").hasClass("alert alert-danger")) {
							$(".log_data .submission_status").toggleClass("alert alert-danger");
						}					
					}
				saved;
				setTimeout(function() {
					  saved.fadeOut(function() {
						  $(this).removeClass("alert alert-danger");
						});
				}, 10000); 
			//	location.reload();
			}
		});
		}, 1000);
	});
});
</script>
</script>
<?php
 include '../templates/backend/members/footer.php'; 
?>