<?php

$title = 'Settings';

include '../templates/backend/members/header.php';

function sanitize_input( $data ) { //filter value function

  global $db;
    
    return mysqli_real_escape_string( $db->link, htmlspecialchars( stripslashes( trim( $data ) ) ) );
}

$get_type = '';

$limit = 5;

$user_id = $_SESSION['id'];

$get_default_type = '';

if ( isset( $_GET["type"] ) && ( $_GET["type"] == 'free' || $_GET["type"] == 'free' || $_GET["type"] == 'role' || $_GET["type"] == 'disposable' ) ) {

  $get_type = sanitize_input( $_GET['type'] );
}

if (isset($_GET["action_type"]) && $_GET["action_type"] == 'default') {
    $get_default_type = sanitize_input($_GET['action_type']);
}

if ( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
    
    if ( isset( $_POST['filter'] ) ) {
      
      if ( isset( $_POST["type"] ) && ( $_POST["type"] == 'free' || $_POST["type"] == 'free' || $_POST["type"] == 'role' || $_POST["type"] == 'disposable' ) ) {
        
          $get_type = sanitize_input( $_POST['type'] );
      }
    }
}

$pn = ( isset( $_GET["page"] ) && is_numeric( $_GET["page"] ) && $_GET["page"] > 0 ) ? sanitize_input( $_GET["page"] ) : 1;
$start_from = ( $pn - 1 ) * $limit;
$i = $start_from;

$sql_w_l = ! empty( $get_default_type ) ? "SELECT * FROM evp_domain_filter_list WHERE user_id = 'all'" : "SELECT * FROM evp_domain_filter_list WHERE user_id = '$user_id'";

if( ! empty( $get_type ) ){

  $account_type = ucfirst( $get_type ) . ' Account';

  $sql_w_l .= " AND e_type = '$account_type'";

  $sql = $sql_w_l . " LIMIT " . $start_from .",". $limit;

}else{
  
  $sql = $sql_w_l . " LIMIT " . $start_from . "," . $limit;
}

// define smtp config details
$smtp_row['smtp_auth'] = '';
$smtp_row['smtp_ssl_verify'] = '';
$smtp_row['smtp_host'] = '';
$smtp_row['smtp_port'] = '';
$smtp_row['smtp_security'] = '';
$smtp_row['smtp_user'] = '';
$smtp_row['smtp_pass'] = '';
// get smtp server list
$smtp_data_sql = "SELECT * FROM evp_smtp_server_list WHERE user_id = '$user_id'";
// get dummy emails
$dummy_emails_sql = "SELECT * FROM evp_dummy_emails";
// get email filter list
$email_filter_sql = "SELECT * FROM evp_email_filter_list";
// get mx filter list
$mx_server_sql = "SELECT * FROM evp_mx_skiplist";
// get product data
$items_sql = "SELECT * FROM evp_products";
?>
<div id="setting_area">
<div class="submission_status"></div>
<?php if( isset( $_SESSION['auth_log'] ) && $_SESSION['auth_log'] == true ){ ?>
<!-- General Setting -->
<div id="general" class="mt-5">				
	<div class="row">
		<div class="col-lg-6">
			<div class="pd-20 card-box mb-30">
			<h5><?php _e('Features Control');?></h5>
				<div class="setting-box mt-4">
					 <form id="feature_options" action="#" method="post" autocomplete="off" autocomplete="chrome-off">
						<div class="form-group row">
						<label class="col-sm-4 col-form-label"><?php _e('Email Campaign');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Control bulk email campaign feature usage');?>"></i></label>
						<div class="col-sm-8">
							<label class="btn_switch">
								<input type="checkbox" name="email_campaigns" id="email_campaigns" value="<?php echo $email_campaigns;?>" <?php if($email_campaigns == 'true'){echo 'checked';} ?>>
								<span class="btn_slider round"></span>
							</label>
						</div>
					  </div>
					  <div class="form-group row">
						<label class="col-sm-4 col-form-label"><?php _e('Inbox Checker');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Inbox or Mailbox checker provides additional feature over bulk email validations');?>"></i></label>
						<div class="col-sm-8">
							<label class="btn_switch">
								<input type="checkbox" name="inbox_checker" id="inbox_checker" value="<?php echo $inbox_checker;?>" <?php if($inbox_checker == 'true'){echo 'checked';} ?>>
								<span class="btn_slider round"></span>
							</label>
						</div>
					  </div>
					  <div class="form-group row">
						<label class="col-sm-4 col-form-label"><?php _e('Blacklist Monitor');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Monitor server host IP blacklist status');?>"></i></label>
						<div class="col-sm-8">
							<label class="btn_switch">
								<input type="checkbox" name="blacklist_check" id="blacklist_check" value="<?php echo $blacklist_check;?>" <?php if($blacklist_check == 'true'){echo 'checked';} ?>>
								<span class="btn_slider round"></span>
							</label>
						</div>
					  </div>
					  <div class="form-group row">
						<label class="col-sm-4 col-form-label"><?php _e('Script Updates Monitor');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Monitor for script updates');?>"></i></label>
						<div class="col-sm-8">
							<label class="btn_switch">
								<input type="checkbox" name="ver_check" id="ver_check" value="<?php echo $ver_check;?>" <?php if($ver_check == 'true'){echo 'checked';} ?>>
								<span class="btn_slider round"></span>
							</label>
						</div>
					  </div>
					 </form>
				</div>
			</div>
		</div>
		
		<div class="col-lg-6">
			<div class="pd-20 card-box mb-30">
			<h5><?php _e('Debug');?></h5>
				<div class="setting-box mt-4">
					 <form id="debug_options" action="#" method="post" autocomplete="off" autocomplete="chrome-off">
					<!--	<div class="form-group row">
						<label class="col-sm-4 col-form-label">Save Logs In DB <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="Enable php server side logging"></i></label>
						<div class="col-sm-8">
							<label class="btn_switch">
								<input type="checkbox" name="save_log_in_db" id="save_log_in_db" value="<?php // echo $save_log_in_db;?>" <?php // if($save_log_in_db == 'true'){echo 'checked';} ?>>
								<span class="btn_slider round"></span>
							</label>
						</div>
					  </div> -->
					  <div class="form-group row">
						<label class="col-sm-4 col-form-label"><?php _e('System Log');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Monitor php server side errors and warnings');?>"></i></label>
						<div class="col-sm-8">
							<label class="btn_switch">
								<input type="checkbox" name="system_debug" id="system_debug" value="<?php echo $system_debug;?>" <?php if($system_debug == 'true'){echo 'checked';} ?>>
								<span class="btn_slider round"></span>
							</label>
						</div>
					  </div>
					  <div class="form-group row">
						<label class="col-sm-4 col-form-label"><?php _e('Scan Log');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Monitor email validation scan log');?>"></i></label>
						<div class="col-sm-8">
							<label class="btn_switch">
								<input type="checkbox" name="scan_debug" id="scan_debug" value="<?php echo $scan_debug;?>" <?php if($scan_debug == 'true'){echo 'checked';} ?>>
								<span class="btn_slider round"></span>
							</label>
						</div>
					  </div>

					  <div class="form-group row" style="display:none;">
						<label class="col-sm-4 col-form-label"><?php _e('Activity Log');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Monitor users activity');?>"></i></label>
						<div class="col-sm-8">
							<label class="btn_switch">
								<input type="checkbox" name="activity_debug" id="activity_debug" value="<?php echo $activity_debug;?>" <?php if($activity_debug == 'true'){echo 'checked';} ?> disabled>
								<span class="btn_slider round"></span>
							</label>
						</div>
					  </div>
					  <div class="form-group row">
						<label class="col-sm-4 col-form-label"><?php _e('SMTP Log');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Monitor all outgoing emails');?>"></i></label>
						<div class="col-sm-8">
							<label class="btn_switch">
								<input type="checkbox" name="smtp_debug" id="smtp_debug" value="<?php echo $smtp_debug;?>" <?php if($smtp_debug == 'true'){echo 'checked';} ?>>
								<span class="btn_slider round"></span>
							</label>
						</div>
					  </div>
					 </form>
				</div>
			</div>
		</div>

		<div class="col-lg-6">
			<div class="pd-20 card-box mb-30">
			<h5><?php _e('Theme Settings');?></h5>
				<div class="setting-box mt-4">
					 <form id="theme_option" action="#" method="post" autocomplete="off" autocomplete="chrome-off">
					  <div class="form-group row">
						<label class="col-sm-4 col-form-label"><?php _e('Panel BG-Color');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Change your panel background color.');?>"></i></label>
						<div class="col-sm-8">
							<input type="color" value="<?php if(!empty($bgColor)) echo $bgColor; ?>" id="bgColorPicker">
							<strong><span id="hexCode"><?php if(!empty($bgColor)) echo $bgColor; ?></span></strong>
								<script>

	

$(document).ready(function() {
	$("#theme_option input[type=color]").on('change', function(e) {
		var timeoutId;		

		clearTimeout(timeoutId);
		timeoutId = setTimeout(function() {
		$.ajax({
			url: "../functions/settings_functions.php",
			type: "POST",
			data: {
				
            },
			dataType: "json",
			beforeSend: function(xhr) {
				$('#theme_option .submission_status').html('Saving...').fadeIn();
			},
			success: function(data) {
				
				saved;
				setTimeout(function() {
					  saved.fadeOut(function() {
						  $(this).removeClass("alert alert-danger");
						});
				}, 10000); 
			//	location.reload();
			
			},
		});
		}, 1000);	
	});
});		</script>
						</div>
					  </div>
					  

					 </form>
				</div>
			</div>
		</div>
		
	<!-- system notification email -->
      <div class="col-md-6">
		 <div class="pd-20 card-box mb-30">
			  <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'theme_options'){ ?>
				<span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
			  <?php } ?>
			  <h5><?php _e('Notification Settings');?></h5>
			  <div class="setting-box mt-4">
				<form id="notify_options" action="#general" method="post" autocomplete="off" autocomplete="chrome-off">
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('System Email Address');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('This email address will get used to send email notifications to users for everything. Only use real email address from same server.');?>"></i></label>
					  <div class="col-sm-8">
						<input type="email" required name="system_email" class="form-control" value="<?php echo (!empty($system_email) ? $system_email : '');?>" placeholder="enter a system admin email">
					  </div>
					</div>
			
	  
          <div class="form-group row">
                  <label class="col-sm-4 col-form-label"><?php _e('Use SMTP');?></label>
            <div class="col-sm-8">
                  <label class="btn_switch">
                    <input type="checkbox" name="sys_smtp" id="sys_smtp" <?php if($sys_smtp == 'true'){echo 'checked';} ?>>
                    <span class="btn_slider round"></span>
                  </label>
            </div>
          </div>
		  
		  <?php if($sys_smtp == 'true') { ?>
			<div class="form-group row">
            <label class="col-sm-4 col-form-label"><?php _e('SMTP Host');?></label>
            <div class="col-lg-8 row">
			<div class="col-sm-8">
              <input type="text" name="smtp_host" class="form-control" value="<?php echo $smtp_host;?>" placeholder="Host" required>
			</div>
			<div class="col-sm-4">
              <input type="number" name="smtp_port" class="form-control" value="<?php echo $smtp_port;?>" placeholder="Port" required>
            </div>
            </div>
          </div>
		  <div class="form-group row">
            <label class="col-sm-4 col-form-label"><?php _e('SMTP Security');?></label>
            <div class="col-sm-8">
              <input type="text" name="smtp_security" class="form-control" value="<?php echo $smtp_security;?>" placeholder="ssl/tls/starttls" required>
            </div>
          </div>

		  <div class="form-group row">
                  <label class="col-sm-4 col-form-label"><?php _e('SMTP Auth?');?></label>
                  <div class="col-sm-8">
                  <label class="btn_switch">
                    <input type="checkbox" name="smtp_auth" id="smtp_auth" <?php if($smtp_auth == 'true'){echo 'checked';} ?>>
                    <span class="btn_slider round"></span>
                  </label>
            </div>
          </div>
		  
          <div class="form-group row">
            <label class="col-sm-4 col-form-label"><?php _e('SMTP Username');?></label>
            <div class="col-sm-8">
              <input type="text" name="smtp_user" class="form-control" value="<?php echo $smtp_user;?>" placeholder="username">
            </div>
          </div>
		  <div class="form-group row">
            <label class="col-sm-4 col-form-label"><?php _e('SMTP Password');?></label>
            <div class="col-sm-8">
              <input type="password" name="smtp_pass" class="form-control" value="<?php echo $smtp_pass;?>" placeholder="password"  autocomplete="off" autocomplete="chrome-off">
            </div>
          </div>
		  
		  <div class="form-group row">
			<label class="col-sm-4 col-form-label"><?php _e('SMTP SSL Verification');?></label>
			<div class="col-sm-8">
				<label class="btn_switch">
                    <input type="checkbox" name="smtp_ssl_verify" id="smtp_ssl_verify" <?php if($smtp_ssl_verify == 'true'){echo 'checked';} ?>>
                    <span class="btn_slider round"></span>
                </label>
			</div>
          </div>
		  
		 <?php } ?>
		  <!-- SMTP  Server -->


		<div class="form-group row">
			<div class="col-sm-12">
               <button type="submit" name="send_mail_test" class="send_mail_test btn btn-info"><?php _e('Connection Test');?></button>
            </div>
          </div>
		  
		  
          <div class="form-group">
            <div class="float-right">
            
            </div>
          </div>

		  
        </form>
			  </div> <!-- /.setting-box -->
			  
			</div>
      </div>
	  
		


			
	</div>
</div>

<script>
$(document).ready(function() {
	$('#general input').on('change', function() {
	event.preventDefault();
		var timeoutId;
		var get_email_campaigns = $(this).closest('#general').find("input[name='email_campaigns']").prop('checked');
		var get_inbox_checker = $(this).closest('#general').find("input[name='inbox_checker']").prop('checked');
		var get_blacklist_check = $(this).closest('#general').find("input[name='blacklist_check']").prop('checked');
		var get_ver_check = $(this).closest('#general').find("input[name='ver_check']").prop('checked');
		var get_system_debug = $(this).closest('#general').find("input[name='system_debug']").prop('checked');
		var get_scan_debug = $(this).closest('#general').find("input[name='scan_debug']").prop('checked');
		var get_activity_debug = $(this).closest('#general').find("input[name='activity_debug']").prop('checked');
		var get_smtp_debug = $(this).closest('#general').find("input[name='smtp_debug']").prop('checked');
		var get_bgColor = $('#theme_option #bgColorPicker').val();
		var get_system_email = $(this).closest('#general').find("input[name='system_email']").val();
		var get_sys_smtp = $(this).closest('#general').find("input[name='sys_smtp']").prop('checked');
		var get_smtp_host = $(this).closest('#general').find("input[name='smtp_host']").val();
		var get_smtp_port = $(this).closest('#general').find("input[name='smtp_port']").val();
		var get_smtp_security = $(this).closest('#general').find("input[name='smtp_security']").val();
		var get_smtp_auth = $(this).closest('#general').find("input[name='smtp_auth']").prop('checked');
		var get_smtp_user = $(this).closest('#general').find("input[name='smtp_user']").val();
		var get_smtp_pass = $(this).closest('#general').find("input[name='smtp_pass']").val();
		var get_smtp_ssl_verify = $(this).closest('#general').find("input[name='smtp_ssl_verify']").prop('checked');
		
		// const AddBGcolor = document.getElementById("bgColorPicker");
		//	var hexCode = document.getElementById("hexCode");

			// get_bgColor.addEventListener("input", setBGColor);
				
			setBGColor();
			// get_bgColor.addEventListener("input", setBGColor);

			function setBGColor() {
				$('.left-side-bar').css('background',get_bgColor);
				$('.header').css('background',get_bgColor);
				$('#theme_option #hexCode').text(get_bgColor)
			}
		
		clearTimeout(timeoutId);
		timeoutId = setTimeout(function() {
		$.ajax({
			url: "../functions/settings_functions.php",
			type: "POST",
			data: {
				email_campaigns: get_email_campaigns,
				inbox_checker: get_inbox_checker,
				blacklist_check: get_blacklist_check,
				ver_check: get_ver_check,
				bgColor: get_bgColor,
				system_debug: get_system_debug,
				activity_debug: get_activity_debug,
				scan_debug: get_scan_debug,
				smtp_debug: get_smtp_debug,
				system_email: get_system_email,
				sys_smtp: get_sys_smtp,
				smtp_host: get_smtp_host,
				smtp_port: get_smtp_port,
				smtp_security: get_smtp_security,
				smtp_auth: get_smtp_auth,
				smtp_user: get_smtp_user,
				smtp_pass: get_smtp_pass,
				smtp_ssl_verify: get_smtp_ssl_verify
            },
			dataType: "json",
			beforeSend: function(xhr) {
				$('.submission_status').html('Saving...').fadeIn();
			},
			success: function(data) {
			//	console.log(data);
				
				var reSuccess = data.success;
				var reError = data.error;
						
				if (reSuccess) {
					var email_campaigns = data.email_campaigns;
					var inbox_checker = data.inbox_checker;
					var blacklist_check = data.blacklist_check;
					var ver_check = data.ver_check;
					var system_debug = data.system_debug;
					var scan_debug = data.scan_debug;
					var activity_debug = data.activity_debug;
					var smtp_debug = data.smtp_debug;
					var system_email = data.system_email;
					var sys_smtp = data.sys_smtp;
					var smtp_host = data.smtp_host;
					var smtp_port = data.smtp_port;
					var smtp_security = data.smtp_security;
					var smtp_auth = data.smtp_auth;
					var smtp_user = data.smtp_user;
					var smtp_pass = data.smtp_pass;
					var smtp_ssl_verify = data.smtp_ssl_verify;
					var bgColor = data.bgColor;
					
					$('#general').closest('#general').find("input[name='email_campaigns']").prop(email_campaigns);
					$('#general').closest('#general').find("input[name='inbox_checker']").prop(inbox_checker);
					$('#general').closest('#general').find("input[name='blacklist_check']").prop(blacklist_check);
					$('#general').closest('#general').find("input[name='ver_check']").prop(ver_check);
					$('#general').closest('#general').find("input[name='system_debug']").prop(system_debug);
					$('#general').closest('#general').find("input[name='scan_debug']").prop(scan_debug);
					$('#general').closest('#general').find("input[name='activity_debug']").prop(activity_debug);
					$('#general').closest('#general').find("input[name='smtp_debug']").prop(smtp_debug);
					$('#general').closest('#general').find("input[name='system_email']").val(system_email);
					$('#general').closest('#general').find("input[name='sys_smtp']").prop(sys_smtp);
					$('#general').closest('#general').find("input[name='smtp_host']").val(smtp_host);
					$('#general').closest('#general').find("input[name='smtp_port']").val(smtp_port);
					$('#general').closest('#general').find("input[name='smtp_security']").val(smtp_security);
					$('#general').closest('#general').find("input[name='smtp_auth']").prop(smtp_auth);
					$('#general').closest('#general').find("input[name='smtp_user']").val(smtp_user);
					$('#general').closest('#general').find("input[name='smtp_ssl_verify']").prop(smtp_ssl_verify);
					$('#general').closest('#general').find("input[id='bgColorPicker']").val(bgColor)
					$('#general').closest('#general').find("span[id='hexCode']").text(bgColor)

					var saved = $(".submission_status").html(reSuccess);
					} else {
						var saved = $(".submission_status").html(reError);
						if(!$(".submission_status").hasClass("alert alert-danger")) {
							$(".submission_status").toggleClass("alert alert-danger");
						}				
					}

				saved;
				setTimeout(function() {
					  saved.fadeOut();
				}, 2000); 
			//	location.reload();
			},
		});
		}, 1000);
	});
	
	$("#notify_options .send_mail_test").on('click', function() {
		event.preventDefault();
		var get_smtp_host = $(this).closest('#notify_options').find("input[name='smtp_host']").val();
		var get_smtp_port = $(this).closest('#notify_options').find("input[name='smtp_port']").val();
		var get_smtp_security = $(this).closest('#notify_options').find("input[name='smtp_security']").val();
		var get_smtp_user = $(this).closest('#notify_options').find("input[name='smtp_user']").val();
		var get_smtp_pass = $(this).closest('#notify_options').find("input[name='smtp_pass']").val();
	
    Swal.fire({
			title: "<?php _e('Test SMTP Connection');?>",
			text: "<?php _e('Insert An Email To Receive');?>",
        input: 'text',
        showCancelButton: true,
			confirmButtonText: '<?php _e('Send Test');?>',
        showLoaderOnConfirm: true,
			heightAuto: false,
        preConfirm: function(text) {
            return new Promise(function(resolve) {
                    $.ajax({
                        url: "../functions/settings_functions.php",
                        method: 'POST',
                        data: {
							smtp_host: get_smtp_host,
							smtp_port: get_smtp_port,
							smtp_security: get_smtp_security,
							smtp_user: get_smtp_user,
							smtp_pass: get_smtp_pass,
								sys_smtp_test: text
                        },
						dataType: "json"
					}).done(function (response) {
						if(response['title'] === 'Success') {
							swal.fire({
								title: "<?php _e('Sent');?>",
							showConfirmButton: true,
							icon: 'success',
							type: "success",
								html: '<?php _e('Email successfully sent');?>',
								heightAuto: false
							})
						} else if(response['title'] === 'Error'){
							swal.fire({
								title: "<?php _e('Connection Error');?>",
							showConfirmButton: true,
							icon: 'error',
							type: "error",
								html: '<?php _e('Could not sent email');?>',
								heightAuto: false
							})
						}
					})
            })
        },
    })
	});

});
</script>

<!-- / General Setting -->
<?php } // General settings end ?>

<?php if($email_campaigns == 'true'){ // enable email campaign settings?>
<!-- Email Campaign Settings -->
<div id="emailcamp_sys" class="mt-5">
<div class="row">
<div class="col-md-12">
	<div class="pd-20 card-box mb-30">
		<div id="smtp_servers">
		  <h5 class=""><?php _e('SMTP Servers');?></h5>
		  <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'smtp_servers'){ ?>
			<span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
		  <?php } ?>
		  
			<div class="mt-4">
				<table class="smtp_servers_table table stripe hover nowrap">
					<thead>
						<tr>
							<th class="table-plus">#</th>
							<th><?php _e('Limit');?></th>
							<th><?php _e('Email');?></th>
							<th><?php _e('Host');?></th>
							<th><?php _e('Port');?></th>
							<th><?php _e('Security');?></th>
							<th><?php _e('SSL Verify?');?></th>
						    <th><?php _e('SMTP Auth?');?></th>
							<th><?php _e('Username');?></th>
							<th><?php _e('Password');?></th>
							<th class="datatable-nosort"><?php _e('Action');?></th>
						</tr>
					</thead>
										
					<tbody>
					  <?php
					  $smtp_data_read = $db->select($smtp_data_sql);
					  $smtp_data_count = mysqli_num_rows($smtp_data_read);
					  if($smtp_data_count > 0){
						  $z = 0;
						while ($row = $smtp_data_read->fetch_assoc()) {
						  $z++; ?>
					  <tr data-target="<?php echo $row['id'] ;?>">
						<td scope="row"><?php echo $z ;?></td>
						<td id="smtp_limit" class="edit_text"><?php echo $row['smtp_limit'] ;?></td>
						<td id="smtp_email" class="edit_text"><?php echo $row['smtp_email'] ;?></td>
						<td id="smtp_host" class="edit_text"><?php echo $row['smtp_host'] ;?></td>
						<td id="smtp_port" class="edit_text"><?php echo $row['smtp_port'] ;?></td>
						<td id="smtp_security" class="edit_text"><?php echo $row['smtp_security'] ;?></td>
						<td id="smtp_ssl_verify" class="edit_text"><?php echo $row['smtp_ssl_verify'] ;?></td>
						<td id="smtp_auth" class="edit_text"><?php echo $row['smtp_auth'] ;?></td>
						<td id="smtp_user" class="edit_text"><?php echo $row['smtp_user'] ;?></td>
						<td id="smtp_pass" class="edit_text"><?php echo $row['smtp_pass'] ;?></td>
						<td>
						    <a class="smtp_test_mail" title="<?php _e('Test Connection');?>"><i class="icon-copy dw dw-mail"></i></a>
							<a class="save" title="<?php _e('Save');?>"><i class="icon-copy dw dw-add"></i></a>
                            <a class="edit" title="<?php _e('Edit');?>"><i class="icon-copy dw dw-edit-1"></i></a>
                            <a class="delete" title="<?php _e('Delete');?>"><i class="icon-copy dw dw-delete-3"></i></a>
						</td>
					  </tr>
					<?php }} ?>

					</tbody>

				</table>
			</div>
		
		</div>

	</div>
</div>


    </div>
	
	
</div>	


<?php } // enable email campaign settings ?>
 
 <?php if( isset( $_SESSION['auth_log'] ) && $_SESSION['auth_log'] == true ){ ?>
<!-- Scanner Settings -->
<div id="scanner_sys" class="mt-5">
	  <div class="row">
      <div class="col-md-6">
		 <div class="pd-20 card-box mb-30">
			  <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'email_scanner_options'){ ?>
				<span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
			  <?php } ?>
			  <h5 class=""><?php _e('Email Scanner Settings');?></h5>
			  <div class="setting-box mt-4">
				<form action="../functions/settings_functions.php#scanner_sys" method="post">
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('Scan from mail');?></label>
					  <div class="col-sm-8">
						<input type="email" required name="scan_from" class="form-control" value="<?php echo (!empty($scan_mail) ? $scan_mail : '');?>" placeholder="<?php _e('enter your scan from mail');?>">
					  </div>
					</div>
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('SMTP Command');?></label>
					  <div class="col-sm-8">							
						<select id="smtp_cmd" class="custom-select2 form-control" name="smtp_cmd" style="width: 100%; height: 38px">
							<optgroup label="<?php if($smtp_cmd != null) { echo 'Selected SMTP Command: '.$smtp_cmd ;} else { echo 'Select a SMTP Command';}?>">
									<?php
										$smtp_cmd_data = ['HELO', 'EHLO'];
									
										if($smtp_cmd != null) {
											echo '<option value="'.$smtp_cmd.'">'.$smtp_cmd.'</option>'; 
										} else {
									?>
										<option value="">-----------------</option>
									<?php } ?>
									<?php if(($key = array_search($smtp_cmd, $smtp_cmd_data)) !== false) {
												unset($smtp_cmd_data[$key]);
											  foreach($smtp_cmd_data as $smtp_cmd){
												echo "<option value='$smtp_cmd'>".$smtp_cmd."</option>";
											  }
										  } else {
											  foreach($smtp_cmd_data as $smtp_cmd){
												echo "<option value='$smtp_cmd'>".$smtp_cmd."</option>";
											  }
										  }
									?>
							</optgroup>
						</select>
																	
					  </div>
					</div>
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('SMTP Scan Port');?></label>
					  <div class="col-sm-8">
						<input type="number" required name="scan_port" class="form-control" value="<?php echo (!empty($scan_port) ? $scan_port : '');?>" placeholder="<?php _e('enter your server open smtp port for scan');?>">
					  </div>
					</div>
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('scan timeout per email (in sec)');?></label>
					  <div class="col-sm-8">
						<input type="number" required name="timeout" class="form-control" value="<?php echo (!empty($scan_timeout) ? $scan_timeout: '');?>" placeholder="<?php _e('Enter timeout value (default 10 sec)');?>">
					  </div>
					</div>
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('total email to batch process');?></label>
					  <div class="col-sm-8">
						<input type="number" required name="batch_limit" class="form-control" value="<?php echo (!empty($batch_limit) ? $batch_limit: '');?>" placeholder="<?php _e('Enter total email fetch amount per query (default 10 email)');?>">
						<small><?php _e('each time fetch how many emails to verify. Increase for speed but may risk of wrong result.');?></small>
					  </div>
					</div>
				</form>
			  </div> <!-- /.setting-box -->
			</div>
			
			<!-- Bulk Scan Settings -->
			<div class="pd-20 card-box mb-30">
			  <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'email_scanner_options'){ ?>
				<span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
			  <?php } ?>
			  <h5><?php _e('Bulk Scan Settings');?></h5>
			  <div class="setting-box mt-4">
				<form id="bulk_scan_settings" action="#scanner_sys" method="post">
					
					<div class="form-group row">
					<label class="col-sm-12 col-form-label"><?php _e('Column Data Set');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('Set custom column header names, be sure to set this before starting csv import. Altering any data set will update database and may lead existing email list data lose.');?>"></i></label>
						<div class="col-sm-12">
						
						  <select id="cc_data" class="cc_data-select2 form-control" name="cc_data" multiple="multiple">
						  <?php foreach($cc_data as $val){ ?>
							  <option selected="selected" value="<?php echo $val; ?>"><?php echo $val; ?></option>
						  <?php } ?>
						  </select>

						</div>
					</div>
				</form>
			  </div> <!-- /.setting-box -->
			</div>
			<!-- Bulk Scan Settings -->
			
	  		<!-- Background Tasks Runner -->
			<div class="pd-20 card-box mb-30">
			  <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'taskrun_options'){ ?>
				<span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
			  <?php } ?>
			  <h5><?php _e('Scan Task Runner');?></h5>
			  <div class="setting-box mt-4">
				<form id="taskrun_options" action="#scanner_sys" method="post">
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('Tasker Hash');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('This is an unique task runner hash key. Which you need to generate and copy as cron job task runner url from bottom and set a cron job for background scan as every 1 minute in hosting panel.');?>"></i></label>
					  <div class="col-sm-8">
						<div class="input-group mb-3">
						  <input type="text" class="form-control" name="tasker_hash" class="form-control" value="<?php echo (!empty($tasker_hash) ? $tasker_hash : '');?>" placeholder="<?php _e('generate your hash key');?>" aria-label="<?php _e('generate your hash key');?>" required readonly>
						  <div class="input-group-append">
							<button style="" type="submit" name="generate_taskHash" class="btn btn-outline-secondary"><?php _e('Generate');?></button>
						  </div>
						</div>
					  </div>
						<div class="alert alert-primary align-middle" role="alert">
						  <p><?php _e('Scan Cron Job');?>: <br>
						  <code> curl <?php echo "$s_url/functions/tasks/scheduler.scan.php?hash=".(!empty($tasker_hash) ? $tasker_hash : 'GENERATE_HASH'); ?></code></p>
						  <p><?php _e('Campaign Cron Job');?>: <br>
						  <code> curl <?php echo "$s_url/functions/tasks/scheduler.campaign.php?hash=".(!empty($tasker_hash) ? $tasker_hash : 'GENERATE_HASH'); ?></code></p>
						</div>
					</div>

				</form>
			  </div> <!-- /.setting-box -->
      </div>
			<!-- / Background Tasks Runner -->
	  
      </div>

	  <?php if($inbox_checker == 'true') { // Inbox Checker Settings; ?>
	  <div class="col-md-6">
		 <div class="pd-20 card-box mb-30">
			  <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'email_scanner_options'){ ?>
				<span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
			  <?php } ?>
			  <h5><?php _e('Inbox Checker Settings');?></h5>
			  <div class="setting-box mt-4">
				<form id="inbox_checker" action="../functions/settings_functions.php#scanner_sys" method="post" autocomplete="off" autocomplete="chrome-off">
				<div class="form-group row">
					<label class="col-sm-12 col-form-label"><?php _e('SMTP Errors');?></label>
					<div class="col-sm-12">
					  <input type="text" name="ic_smtp_errors" class="form-control" value="<?php echo $ic_smtp_errors;?>" data-role="tagsinput" placeholder="<?php _e('add error string');?>">
					</div>
				</div>
			    <p><?php _e('Configure IMAP & SMTP from same mail server.');?></p>
				
				<h6><?php _e('IMAP Config');?></h6>

				  <div class="form-group row">
					<label class="col-sm-4 col-form-label"><?php _e('IMAP Host');?></label>
					<div class="col-lg-8 row">
					<div class="col-sm-8">
					  <input type="text" name="ic_imap_host" class="form-control" value="<?php echo $ic_imap_host;?>" placeholder="<?php _e('Host');?>" required>
					</div>
					<div class="col-sm-4">
					  <input type="number" name="ic_imap_port" class="form-control" value="<?php echo $ic_imap_port;?>" placeholder="<?php _e('Port');?>" required>
					</div>
					</div>
				  </div>
						
				<h6><?php _e('SMTP Config');?></h6>
				
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('Send Email From');?> <i class="icon-copy dw dw-question-1" data-container="body" data-toggle="tooltip" data-placement="top" data-original-title="<?php _e('This email address will get used to send real dummy email to scanning csv file list.');?>"></i></label>
					  <div class="col-sm-8">
						<input type="email" required name="ic_send_mail" class="form-control" value="<?php echo (!empty($ic_send_mail) ? $ic_send_mail : '');?>" placeholder="<?php _e('enter email address to check inbox');?>">
					  </div>
					</div>
					
					
			<div class="form-group row">
                  <label class="col-sm-4 col-form-label"><?php _e('Use SMTP');?></label>
                <div class="col-sm-8">
                  <label class="btn_switch">
                    <input type="checkbox" name="ic_smtp" id="ic_smtp" <?php if($ic_smtp == 'true'){echo 'checked';} ?>>
                    <span class="btn_slider round"></span>
                  </label>
					  </div>
					</div>
		  
		  <?php if($ic_smtp == 'true') { ?>
					<div class="form-group row">
            <label class="col-sm-4 col-form-label"><?php _e('SMTP Host');?></label>
            <div class="col-lg-8 row">
					  <div class="col-sm-8">
              <input type="text" name="ic_smtp_host" class="form-control" value="<?php echo $ic_smtp_host;?>" placeholder="<?php _e('Host');?>" required>
			</div>
			<div class="col-sm-4">
              <input type="number" name="ic_smtp_port" class="form-control" value="<?php echo $ic_smtp_port;?>" placeholder="<?php _e('Port');?>" required>
            </div>
					  </div>
					</div>
					<div class="form-group row">
            <label class="col-sm-4 col-form-label"><?php _e('SMTP Security');?></label>
					  <div class="col-sm-8">
              <input type="text" name="ic_smtp_security" class="form-control" value="<?php echo $ic_smtp_security;?>" placeholder="<?php _e('ssl/tls/starttls');?>" required>
            </div>
          </div>

		  <div class="form-group row">
                  <label class="col-sm-4 col-form-label"><?php _e('SMTP Auth?');?></label>
                  <div class="col-sm-8">
                  <label class="btn_switch">
                    <input type="checkbox" name="ic_smtp_auth" id="ic_smtp_auth" <?php if($ic_smtp_auth == 'true'){echo 'checked';} ?>>
                    <span class="btn_slider round"></span>
                  </label>
            </div>
          </div>
		  
          <div class="form-group row">
            <label class="col-sm-4 col-form-label"><?php _e('SMTP Username');?></label>
            <div class="col-sm-8">
              <input type="text" name="ic_smtp_user" class="form-control" value="<?php echo $ic_smtp_user;?>" placeholder="<?php _e('username');?>">
            </div>
          </div>
		  <div class="form-group row">
            <label class="col-sm-4 col-form-label"><?php _e('SMTP Password');?></label>
            <div class="col-sm-8">
              <input type="password" name="ic_smtp_pass" class="form-control" value="<?php echo $ic_smtp_pass;?>" placeholder="<?php _e('password');?>"  autocomplete="off" autocomplete="chrome-off">
					  </div>
					</div>
		  
					<div class="form-group row">
			<label class="col-sm-4 col-form-label"><?php _e('SMTP SSL Verification');?></label>
					  <div class="col-sm-8">
				<label class="btn_switch">
                    <input type="checkbox" name="ic_smtp_ssl_verify" id="ic_smtp_ssl_verify" <?php if($ic_smtp_ssl_verify == 'true'){echo 'checked';} ?>>
                    <span class="btn_slider round"></span>
                </label>
					  </div>
					</div>
		  
		 <?php } ?>
		 <!-- SMTP  Server -->


		<div class="form-group row">
			<div class="col-sm-12">
               <button type="submit" name="send_mail_test" class="send_mail_test btn btn-info"><?php _e('Connection Test');?></button>
			</div>
          </div>
		  
		  
          <div class="form-group">
            <div class="float-right">
            
					  </div>
					</div>

		  
				</form>
			  </div> <!-- /.setting-box -->
			  
			</div>
      </div>
	  
 <?php } // Inbox Checker Settings; ?>
	  
	  
	<!-- Inbox Checker - Dummy Emails -->
	<?php if($inbox_checker == 'true') { ?>
	<div class="col-md-12">
		 <div class="pd-20 card-box mb-30">
			<div id="dummy_emails_list">
			  <h5 class=""><?php _e('Inbox Checker - Dummy Emails');?></h5>
			  <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'dummy_emails_save_data'){ ?>
				<span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
			  <?php } ?>
			  
				<div class="mt-4">
					<table class="dummy_emails_table table stripe hover nowrap">
						<thead>
							<tr>
								<th class="table-plus">#</th>
								<th class="datatable-nosort"><?php _e('Subject');?></th>
								<th class="datatable-nosort"><?php _e('Message');?></th>
								<th class="datatable-nosort"><?php _e('Action');?></th>
							</tr>
						</thead>
											
						<tbody>
						  <?php
						  $user_read = $db->select($dummy_emails_sql);
						  $count4 = mysqli_num_rows($user_read);
						  if($count4 > 0){
							$z = 0;
							while ($row = $user_read->fetch_assoc()) {
							  $z++; ?>
						  <tr data-target="<?php echo $row['id'] ;?>">
							<td scope="row"><?php echo $z ;?></td>
							<td id="sub" class="edit_text"><?php echo $row['sub'] ;?></td>
							<td id="msg" class="edit_text"><?php echo $row['msg'] ;?></td>
							<td>
								<a class="save" title="<?php _e('Save');?>"><i class="icon-copy dw dw-add"></i></a>
								<a class="edit" title="<?php _e('Edit');?>"><i class="icon-copy dw dw-edit-1"></i></a>
								<a class="delete" title="<?php _e('Delete');?>"><i class="icon-copy dw dw-delete-3"></i></a>
							</td>
						  </tr>
						<?php }} ?>

						</tbody>

					</table>
						</div>
							
					</div>

			</div>
      </div>
	<?php } ?>
	<!-- / Inbox Checker - Dummy Emails -->
	  
  </div>
  
</div>
<!-- / Scanner Settings -->

<!-- Scanner Settings -->
<script>
/**
* Email Scanner Settings
**/
$(document).ready(function() {

	$(".cc_data-select2").select2({
		tags: true
		// tokenSeparators: [',', ' ']
	})

	$("#scanner_sys input, #scanner_sys select").on('change', function(e) {
		e.preventDefault();
		var timeoutId;
		var get_scan_from = $(this).closest('#scanner_sys').find("input[name='scan_from']").val();
		var get_scan_port = $(this).closest('#scanner_sys').find("input[name='scan_port']").val();
		var get_timeout = $(this).closest('#scanner_sys').find("input[name='timeout']").val();
		var get_batch_limit = $(this).closest('#scanner_sys').find("input[name='batch_limit']").val();

		var $get_smtp_cmd = $("select[id='smtp_cmd']");
		var get_smtp_cmd_val = $get_smtp_cmd.select2('data')[0]['id'];
		var get_smtp_cmd_label = $get_smtp_cmd.select2('data')[0]['text']; 

		var get_cc_data = $("select[id='cc_data']").select2("val");
		//console.log(get_cc_data);

		// Inbox Checker SMTP Data
		var get_ic_smtp_errors = $(this).closest('#scanner_sys').find("input[name='ic_smtp_errors']").val();
		var get_ic_send_mail = $(this).closest('#scanner_sys').find("input[name='ic_send_mail']").val();
		var get_ic_smtp = $(this).closest('#scanner_sys').find("input[name='ic_smtp']").prop('checked');
		var get_ic_imap_host = $(this).closest('#scanner_sys').find("input[name='ic_imap_host']").val();
		var get_ic_imap_port = $(this).closest('#scanner_sys').find("input[name='ic_imap_port']").val();
		var get_ic_smtp_host = $(this).closest('#scanner_sys').find("input[name='ic_smtp_host']").val();
		var get_ic_smtp_port = $(this).closest('#scanner_sys').find("input[name='ic_smtp_port']").val();
		var get_ic_smtp_security = $(this).closest('#scanner_sys').find("input[name='ic_smtp_security']").val();
		var get_ic_smtp_auth = $(this).closest('#scanner_sys').find("input[name='ic_smtp_auth']").prop('checked');
		var get_ic_smtp_user = $(this).closest('#scanner_sys').find("input[name='ic_smtp_user']").val();
		var get_ic_smtp_pass = $(this).closest('#scanner_sys').find("input[name='ic_smtp_pass']").val();
		var get_ic_smtp_ssl_verify = $(this).closest('#scanner_sys').find("input[name='ic_smtp_ssl_verify']").prop('checked');
		
		
		clearTimeout(timeoutId);
		timeoutId = setTimeout(function() {
		$.ajax({
			url: "../functions/settings_functions.php",
			type: "POST",
			data: {
				scan_from: get_scan_from,
				scan_port: get_scan_port,
				timeout: get_timeout,
				batch_limit: get_batch_limit,
				smtp_cmd: get_smtp_cmd_val,
				cc_data : get_cc_data,
				ic_smtp_errors : get_ic_smtp_errors,
				ic_send_mail : get_ic_send_mail,
				ic_smtp : get_ic_smtp,
				ic_imap_host : get_ic_imap_host,
				ic_imap_port : get_ic_imap_port,
				ic_smtp_host : get_ic_smtp_host,
				ic_smtp_port : get_ic_smtp_port,
				ic_smtp_security : get_ic_smtp_security,
				ic_smtp_auth : get_ic_smtp_auth,
				ic_smtp_user : get_ic_smtp_user,
				ic_smtp_pass : get_ic_smtp_pass,
				ic_smtp_ssl_verify : get_ic_smtp_ssl_verify
            },
			dataType: "json",
			beforeSend: function(xhr) {
				$('.submission_status').html('Saving...').css("display", "flex").hide().fadeIn();
			},
			success: function(data) {
				var reSuccess = data.success;
				var reError = data.error;
				if (reSuccess) {
						 //console.log(reSuccess);		
						var scan_from = data.scan_from;
						var scan_port = data.scan_port;
						var timeout = data.timeout;
						var batch_limit = data.batch_limit;
						var smtp_cmd = data.smtp_cmd;
						var cc_data = data.cc_data;
						var ic_smtp_errors = data.ic_smtp_errors;
						var ic_send_mail = data.ic_send_mail;
						var ic_smtp = data.ic_smtp;
						var ic_imap_host = data.ic_imap_host;
						var ic_imap_port = data.ic_imap_port;
						var ic_smtp_host = data.ic_smtp_host;
						var ic_smtp_port = data.ic_smtp_port;
						var ic_smtp_security = data.ic_smtp_security;
						var ic_smtp_auth = data.ic_smtp_auth;
						var ic_smtp_user = data.ic_smtp_user;
						var ic_smtp_pass = data.ic_smtp_pass;
						var ic_smtp_ssl_verify = data.ic_smtp_ssl_verify;
						
						$("#scanner_sys").closest('#scanner_sys').find("input[name='scan_from']").val(scan_from);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='scan_port']").val(scan_port);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='timeout']").val(timeout);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='batch_limit']").val(batch_limit);
						$("#scanner_sys").closest('#scanner_sys').find("select[name='smtp_cmd']").val(smtp_cmd);
						$('#scanner_sys').closest('#scanner_sys').find("input[name='cc_data']").val(cc_data);
						$('#scanner_sys').closest('#scanner_sys').find("input[name='ic_smtp_errors']").val(ic_smtp_errors);
						$('#scanner_sys').closest('#scanner_sys').find("input[name='ic_send_mail']").val(ic_send_mail);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_smtp']").prop(ic_smtp);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_imap_host']").val(ic_imap_host);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_imap_port']").val(ic_imap_port);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_smtp_host']").val(ic_smtp_host);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_smtp_port']").val(ic_smtp_port);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_smtp_security']").val(ic_smtp_security);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_smtp_auth']").val(ic_smtp_auth);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_smtp_user']").val(ic_smtp_user);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_smtp_pass']").val(ic_smtp_pass);
						$("#scanner_sys").closest('#scanner_sys').find("input[name='ic_smtp_ssl_verify']").val(ic_smtp_ssl_verify);
						
						var saved = $(".submission_status").html(reSuccess);
					} else {
						var saved = $(".submission_status").html(reError);
						if(!$(".submission_status").hasClass("alert alert-danger")) {
							$(".submission_status").toggleClass("alert alert-danger");
						}					
					}
				saved;
				setTimeout(function() {
					  saved.fadeOut(function() {
						  $(this).removeClass("alert alert-danger");
						});
				}, 1000); 
			//	location.reload();
			}
		});
		}, 1000);
	});
	
	$("#scanner_sys .send_mail_test").on('click', function() {
		event.preventDefault();
		var get_smtp_host = $(this).closest('#scanner_sys').find("input[name='ic_smtp_host']").val();
		var get_smtp_port = $(this).closest('#scanner_sys').find("input[name='ic_smtp_port']").val();
		var get_smtp_security = $(this).closest('#scanner_sys').find("input[name='ic_smtp_security']").val();
		var get_smtp_user = $(this).closest('#scanner_sys').find("input[name='ic_smtp_user']").val();
		var get_smtp_pass = $(this).closest('#scanner_sys').find("input[name='ic_smtp_pass']").val();
		
		Swal.fire({
			title: "Test SMTP Connection",
			text: "Insert An Email To Receive",
			input: 'text',
			showCancelButton: true,
			confirmButtonText: 'Send Test',
			showLoaderOnConfirm: true,
			heightAuto: false,
			preConfirm: function(text) {
				return new Promise(function(resolve) {
						$.ajax({
							url: "../functions/settings_functions.php",
							method: 'POST',
							data: {
								smtp_host: get_smtp_host,
								smtp_port: get_smtp_port,
								smtp_security: get_smtp_security,
								smtp_user: get_smtp_user,
								smtp_pass: get_smtp_pass,
								ic_smtp_test: text
							},
							dataType: "json"
						}).done(function (response) {
							if(response['title'] === 'Success') {
								swal.fire({
								title: "<?php _e('Sent');?>",
								showConfirmButton: true,
								icon: 'success',
								type: "success",
								html: '<?php _e('Email successfully sent');?>',
								heightAuto: false
								})
							} else if(response['title'] === 'Error'){
								swal.fire({
								title: "<?php _e('Connection Error');?>",
								showConfirmButton: true,
								icon: 'error',
								type: "error",
								html: '<?php _e('Could not sent email');?>',
								heightAuto: false
								})
							}
						})
				})
			},
		})
	});
	
	$("#taskrun_options button[name='generate_taskHash']").on('click', function(e) {
		var timeoutId;
		var get_taskHash = $(this).closest('#taskrun_options').find("input[name='tasker_hash']").val();
		clearTimeout(timeoutId);
		timeoutId = setTimeout(function() {
		//console.log('Saving to the db');
		//form = $('#taskrun_options');
		$.ajax({
			url: "../functions/settings_functions.php",
			type: "POST",
			//data: form.serialize(), // serializes the form's elements.
			data: {
				tasker_hash : get_taskHash
            },
			dataType: "json",
			beforeSend: function(xhr) {
				// Saving Data
				$('#taskrun_options .submission_status').html('<?php _e('Saving');?>...').fadeIn();
			},
			success: function(data) {
				var reSuccess = data.success;
				var reError = data.error;
			//	console.log(reSuccess);								
				if (reSuccess) {
					var tasker_hash = data.tasker_hash;
					$('#taskrun_options input').closest('#taskrun_options').find("input[name='tasker_hash']").val(tasker_hash);
			//		console.log(tasker_hash);
					var saved = $("#taskrun_options .submission_status").html(reSuccess);
					} else {
						var saved = $("#taskrun_options .submission_status").html(reError);
						if(!$("#taskrun_options .submission_status").hasClass("alert alert-danger")) {
							$("#taskrun_options .submission_status").toggleClass("alert alert-danger");
						}					
					}
				saved;
				setTimeout(function() {
					  saved.fadeOut(function() {
						  $(this).removeClass("alert alert-danger");
						});
				}, 10000); 
				location.reload();
			
			},
		});
		}, 1000);
	event.preventDefault();		
	});
});
</script>
<!-- / Scanner Settings -->

<?php } ?>
 
<!-- Filters Setting -->
<div id="filters" class="mt-5">
<div class="row">
  
<!-- Domain Filter Setting -->
  <div class="col-md-12">
    <div class="pd-20 card-box mb-30">
      <h5 class=""><?php _e('Domain Filter Settings');?></h5>
      <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'domain_filter_options'){ ?>
        <span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
      <?php } ?>
      <div class="mt-4 row">
        <div class="col-lg-6 border-right pr-4">
          <form class="form-inline" action="settings.php<?php echo (!empty($get_default_type) ? '?action_type=default':'');?>#filters" method="post">
            <div class="form-group mr-3 mb-2">
              <select name="type" class="form-control form-control-sm">
                <option value=""><?php _e('Select Type All');?></option>
                <option <?php if($get_type == 'free'){echo 'selected';}?> value="free"><?php _e('Free Account');?></option>
                <option <?php if($get_type == 'role'){echo 'selected';}?> value="role"><?php _e('Role Account');?></option>
                <option <?php if($get_type == 'disposable'){echo 'selected';}?> value="disposable"><?php _e('Disposable');?></option>
                <option <?php if($get_type == 'unsupported'){echo 'selected';}?> value="unsupported"><?php _e('Unsupported');?></option>
              </select>
            </div>
            <button type="submit" name="filter" class="btn btn-primary mb-2 btn-sm"><?php _e('Filter');?></button>
            <?php if(!empty($get_default_type)){ ?>
              <a href="settings.php#filters" class="btn btn-sm btn-light ml-3 mb-1"><?php _e('Yours');?></a>
            <?php }else{?>
              <a href="settings.php?action_type=default#filters" class="btn btn-sm btn-light ml-3 mb-1"><?php _e('Default value');?></a>
            <?php }?>
			<?php if( isset( $_SESSION['auth_log'] ) && $_SESSION['auth_log'] == true ): ?>
				<a class="df_update_now btn btn-sm btn-primary ml-3 mb-1" href="#"><?php _e('Sync External List');?></a> 
			<?php endif; ?>
          </form>
          <table class="table table-sm">
            <thead>
              <tr>
                <th scope="col"><?php _e('SL');?></th>
                <th scope="col"><?php _e('Domain Name');?></th>
                <th scope="col"><?php _e('Account Type');?></th>
                <th scope="col"><?php _e('Action');?></th>
              </tr>
            </thead>
            <tbody>
              <?php
              $user_read = $db->select($sql);
              $count4 = mysqli_num_rows($user_read);
              if($count4 > 0){
                while ($row = $user_read->fetch_assoc()) {
                  $i++; ?>
              <tr>
                <th scope="row"><?php echo $i ;?></th>
                <td id="name_<?php echo $i ;?>"><?php echo $row['name'] ;?></td>
                <td id="type_<?php echo $i ;?>"><?php echo $row['e_type'] ;?></td>
                <td>
                  <?php if ($row['user_id'] == 'all') { ?>
                    <span class="badge badge-light"><?php _e('Default');?></button>
                  <?php }else{ ?>
                    <form class="" action="../functions/settings_functions.php#filters" method="post">
                      <span table-id = "<?php echo $i ;?>" data-target = "<?php echo $row['id'] ;?>" class="edit-btn cursor-pointer mr-2 btn btn-sm btn-light"><i class="icon-copy dw dw-edit"></i></span>
                      <input type="number" hidden name="user_id" value="<?php echo $user_id;?>">
                      <input type="text" hidden name="target_id" value="<?php echo $row['id'] ;?>">
                      <button type="submit" name="domain_filter_del_btn" class="btn btn-sm btn-light" onclick="return confirm('<?php _e('you want to delete?');?>');"><i class="icon-copy dw dw-trash"></i></button>
                    </form>
                  <?php }?>
                   </td>
              </tr>
            <?php }} ?>

            </tbody>
          </table>
          <!-- pagination section -->

          <div class="pagination-sec">

            <ul class="pagination float-right">

            <?php
              $sql_read_p = $db->select($sql_w_l);
              $count_row = mysqli_num_rows($sql_read_p);
              $total_pages = ceil($count_row / $limit);
              $k = (($pn+1>$total_pages)?$total_pages-1:(($pn-1<1)?2:$pn));
              $pagLink = "";
              if($total_pages > 1){
              if($pn>=2){
                  echo "<li class='page-item'><a class='page-link' href='".$settings_page."?page=".($pn-1).(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'> < </a></li>";
                  echo "<li class='page-item'><a class='page-link' href='".$settings_page."?page=1".(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'> 1 </a></li>";
                  if(($pn-1) > 2){
                    echo "<li class='page-item'><a class='page-link' href='".$settings_page."?page=".($pn-2).(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'> ... </a></li>";
                  }
              }
              if($pn == 1){
                echo "<li class='page-item active'><a class='page-link' href='".$settings_page."?page=1" .(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'> 1 </a></li>";
              }
              for ($i=-1; $i<=1; $i++) {
                  if($k+$i != 1 && $k+$i != $total_pages && $k+$i < $total_pages && $k+$i > 0){
                    if($k+$i==$pn)
                      $pagLink .= "<li class='page-item active'><a class='page-link' href='".$settings_page."?page=".($k+$i).(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'>".($k+$i)."</a></li>";
                    else
                      $pagLink .= "<li class='page-item'><a class='page-link' href='".$settings_page."?page=".($k+$i).(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'>".($k+$i)."</a></li>";
                  }
              };
              echo $pagLink;
              if($pn == $total_pages){
                echo "<li class='page-item active'><a class='page-link' href='".$settings_page."?page=".$total_pages.(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'> ".$total_pages." </a></li>";
              }
              if($pn<$total_pages){
                  if(($total_pages-$pn) > 2){
                    echo "<li class='page-item'><a class='page-link' href='".$settings_page."?page=".($pn+2).(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'> ... </a></li>";
                  }
                  echo "<li class='page-item'><a class='page-link' href='".$settings_page."?page=".$total_pages.(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'> ".$total_pages." </a></li>";
                  echo "<li class='page-item'><a class='page-link' href='".$settings_page."?page=".($pn+1).(!empty($get_type) ? '&type='.$get_type : '').(!empty($get_default_type) ? '&action_type=default':'').'#filters'."'> > </a></li>";
              }
            }

            ?>

            </ul>

           </div>
		   										  
			<script>
			$(document).ready(function() {
			$("#filters .df_update_now").click(function() {
				Swal.fire({
					title: "<?php _e('Sync Confirmation');?>",
					html: "<p style='color: #009c5d;text-transform: uppercase;font-size: 16px;font-weight: bold;'><?php _e('Would you like to syncronize email filter list with up to date version from EVP  server?');?></p> <p style='color: #e74a3b;font-size: 16px;font-weight: bold;'> <?php _e('Before updating always make sure to backup existing');?> <span style='color:#0063ff;'><?php _e('database');?></span> <?php _e('and');?> <span style='color:#0063ff;'><?php _e('script files');?></span> <?php _e("incase synchronization fails. We won't be responsible for any type of data lose!");?></p>",
					icon: 'info',
					type: "info",
					showCancelButton: true,
					confirmButtonText: '<?php _e('Yes!');?>',
					showLoaderOnConfirm: true,
					heightAuto: false,
					preConfirm: function(text) {
						return new Promise(function(resolve) {
								$.ajax({
									url: "../functions/df_updater.php",
									method: 'POST',
									data: {
										df_updater: 'df_filter_list'
									},
									dataType: "json"
								}).done(function (response) {
										swal.fire({
										title: "<?php _e('Sync Started');?>",
										showConfirmButton: true,
										icon: 'success',
										type: "success",
										html: '<?php _e('updating in background');?>...',
										heightAuto: false
										})
								})
						})
					},
				})
				event.preventDefault();
			});
			});
			</script>


        </div>
        <div id="add-sec" class="col-lg-6 pl-lg-4">
          <div class="">
            <h6 class=""><?php _e('Add new Account type');?> <button id="add-more-btn" class="btn btn-sm btn-link"><i class="icon-copy dw dw-add"></i> <?php _e('Add multiple');?></button> </h6>
          </div>
          <div class="text-danger" id="add-more-error">

          </div>
          <div id="" class="form-group mt-3">
          <form class="" action="../functions/settings_functions.php#filters" method="post">
            <input type="number" hidden name="user_id" value="<?php echo $user_id;?>">
            <div class="row">
              <label for="" class="col-6"><?php _e('Domain Name');?></label>
              <label for="" class="col-6"><?php _e('Account Type');?></label>
            </div>
            <div id="add-account-type-sec">
              <div class="row mb-2">
                <input required hidden name="listing_value[]" value="0">
                <div class="col-6">
                  <input required type="text" name="name_0" class="form-control form-control-sm" value="" placeholder="<?php _e('Enter Domain Name');?>">
                </div>
                <div class="col-6">
                  <select required name="type_0" class="form-control form-control-sm">
                    <option value="" selected><?php _e('Select Account type');?></option>
                    <option value="Free Account"><?php _e('Free Account');?></option>
                    <option value="Role Account"><?php _e('Role Account');?></option>
                    <option value="Disposable Account"><?php _e('Disposable');?></option>
                    <option value="Unsupported Domain"><?php _e('Unsupported Domain');?></option>
                  </select>
                </div>
              </div>
            </div>
            <button type="submit" name="domain_filter_save_btn" class="btn btn-sm btn-info pl-4 pr-4 mt-2"><?php _e('Add');?></button>
          </form>
          </div>
        </div>
        <!-- update -->
        <div id="edit-sec" class="col-lg-6 pl-lg-4">
          <div class="">
            <h6 id="edit-target-value"> </h6>
          </div>
          <div id="" class="form-group mt-3">
            <div class="row">
              <label for="" class="col-6"><?php _e('Domain Name');?></label>
              <label for="" class="col-6"><?php _e('Account Type');?></label>
            </div>
            <form class="" action="../functions/settings_functions.php#filters" method="post">
              <input type="number" hidden name="user_id" value="<?php echo $user_id;?>">
              <input type="text" id="target-id" hidden name="target_id" value="">
            <div>
              <div class="row mb-2">
                <div class="col-6">
                  <input required id="edit-target-name" type="text" name="name" class="form-control form-control-sm" value="" placeholder="<?php _e('Enter Domain Name');?>">
                </div>
                <div class="col-6">
                  <select required id="edit-target-type" name="type" class="form-control form-control-sm">
                    <option value="" selected><?php _e('Select Account type');?></option>
                    <option value="Free Account"><?php _e('Free Account');?></option>
                    <option value="Role Account"><?php _e('Role Account');?></option>
                    <option value="Disposable Account"><?php _e('Disposable');?></option>
                    <option value="Unsupported Domain"><?php _e('Unsupported');?></option>
                  </select>
                </div>
              </div>
            </div>
            <button type="submit" name="domain_filter_edit_btn" class="btn btn-sm btn-info pl-4 pr-4 mt-2"><?php _e('Update');?></button>
            <a id="cancel-edit" class="btn btn-sm btn-dark pl-4 pr-4 mt-2 text-white cursor-pointer"><?php _e('Cancel');?></a>
          </form>
          </div>
        </div>
        <!--end update -->
      </div>

    </div>
  </div>
  
  
<script>
// Domain type Filter
  $('#add-more-btn').click(function(){
    var count_more_cont = $('.add-more-type-cont').length;
    if(count_more_cont <= 0){
      var index = 1;
    }else{
      var last_count = $('.add-more-type-cont').last().attr('id');
      var last_count = last_count.substring(last_count.lastIndexOf("-") + 1, last_count.length);
      var index = parseInt(last_count) +1;
    }
    if(count_more_cont < 9){
        $('#add-account-type-sec').append('<div id="add-more-'+index+'" class="row mb-2 add-more-type-cont"> <input required hidden name="listing_value[]" value="'+index+'"> <div class="col-6"><input required type="text" name="name_'+index+'" class="form-control form-control-sm" value="" placeholder="<?php _e('Enter Domain Name');?>"></div><div class="col-6"><div class="input-group input-group-sm"><select required name="type_'+index+'" class="custom-select" id="inputGroupSelect04" aria-label="Example select with button addon"><option value="" selected><?php _e('Select Account type');?></option><option value="Free Account"><?php _e('Free Account');?></option><option value="Role Account"><?php _e('Role Account');?></option><option value="Disposable Account"><?php _e('Disposable');?></option><option value="Unsupported Domain"><?php _e('Unsupported Domain');?></option></select><div class="input-group-append ml-1"><button id="'+index+'" class="btn btn-outline-secondary cancel-btn-more-type" type="button"><i class="icon-copy dw dw-delete-1"></i></button></div></div></div></div>');
    }else{
      $('#add-more-error').text('<?php _e('Cannot add more than 10 item at a time!');?>');
    }
    $('.cancel-btn-more-type').click(function(){
      var get_id_value = $(this).attr('id');
   //   console.log(get_id_value);
      $('#add-more-'+get_id_value).remove();
      $('#add-more-error').text('');
    })
  });
  $('.edit-btn').click(function(){
    var target_id = $(this).attr('data-target');
    var index_id = $(this).attr('table-id');
    var target_name = document.getElementById("name_"+index_id).innerHTML;
    var target_type = document.getElementById("type_"+index_id).innerHTML;
    $('#edit-target-value').text(index_id + '. Update Value');
 //   console.log(target_id);
    $('#edit-target-name').val(target_name);
    $("#edit-target-type").val(target_type);
    $("#target-id").val(target_id);
    $('#edit-sec').css('display','block');
    $('#add-sec').css('display','none');
  });
  $('#cancel-edit').click(function(){
    $('#edit-sec').css('display','none');
    $('#add-sec').css('display','block');
  });
</script>
<!-- / Domain Filter Setting -->


<!-- Email Address Filter Setting -->
<div class="col-md-12">
	<div class="pd-20 card-box mb-30">
		<div id="email_filter_list">
		  <h5 class=""><?php _e('Email Add. Filter Settings');?></h5>
		  <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'email_filter_save_data'){ ?>
			<span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
		  <?php } ?>
		  
			<div class="mt-4">
				<table class="email_filter_table table stripe hover nowrap">

					<thead>
						<tr>
							<th class="table-plus">#</th>
							<th><?php  _e('Email Address');?></th>
						</tr>
					</thead>
										
					<tbody>
					  <?php
					  $user_read = $db->select($email_filter_sql);
					  $count4 = mysqli_num_rows($user_read);
					  if($count4 > 0){
						$z = 0;
						while ($row = $user_read->fetch_assoc()) {
						  $z++; 
						   ?>
					  <tr data-target="<?php  echo $row['id'] ;?>">
						<td scope="row"><?php  echo $z ;?></td>
						<td id="email_add>" class="edit_text"><?php  echo $row['email_address'] ;?></td>
					  </tr>
					<?php  }} ?>

					</tbody>
					
				</table>
			</div>
						
						
						
<!-- Import Modal -->
 <!-- Modal -->
          <div class="modal fade" id="ImportEmail" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="exampleModalLabel">CSV file import</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closeCSVModal">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                   <form id="upload_csv" enctype="multipart/form-data">
                    
                    <label>Select CSV File</label>
                    <input type="file" name="file" id="file" accept=".csv" class="form-control"/>
                     <div id="select_colum" class="mt-3"></div> 
                </div>
                <div class="modal-footer">
                  <input type="submit" class="btn btn-info" id="import" value="Import" name="import"/>
                </form>
                </div>
              </div>
            </div>
          </div>

       <!--  Add Email Modal --> 
      <!-- Modal -->
    <div class="modal fade" id="AddEmail" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="exampleModalLabel">Add New</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                    <label>Email Address</label>
                    <input type="email" name="email_address" id="email_address" class="form-control" />
                </div>
                <div class="modal-footer">
                <button type="button" class="btn btn-info" id="add_email_button">Add</button>
                </div>
              </div>
            </div>
    </div>
    <!-- End of Add Email Model -->

     <!--  Edit Email Modal --> 
      <!-- Modal -->
        <div class="modal fade" id="EditEmail" tabindex="-1" role="dialog"  aria-hidden="true">
            <div class="modal-dialog" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="exampleModalLabel">Update Email Address</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <form id="update_form">
                <div class="modal-body" id="editEmailModalBody">
                    
                </div>
                <div class="modal-footer">
                <input type="submit" class="btn btn-info" id="update_email_button" value="Update" /></form>
                </div>
              </div>
            </div>
		</div>
    <!-- End of Edit Email Model -->
              <!--  <table class="table table-striped table-bordered" id="email_filter_table">
                 <thead>
                  <tr>
                   <th>#</th>
                   <th>Email Address</th>
                   <th>RID</th>
                  </tr>
                 </thead>
                <tbody></tbody>
                </table> -->
		</div>
	</div>
</div> <!-- // Email Address Filter Setting -->


<?php if(isset($_SESSION['auth_log']) && $_SESSION['auth_log'] == true){ ?>
<!-- MX Server Filter Setting -->
<div class="col-md-12">
	<div class="pd-20 card-box mb-30">
  <div id="mx_server_filter">
		  <h5 class=""><?php _e('MX Server Filter Settings');?></h5>
      <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'mx_server_save_data'){ ?>
        <span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
      <?php } ?>
		  
			<div class="mt-4">
				<table class="mx_filter_table table stripe hover nowrap">
            <thead>
              <tr>
							<th class="table-plus">#</th>
							<th><?php _e('Server Name');?></th>
							<th><?php _e('Reason');?></th>
							<th class="datatable-nosort"><?php _e('Action');?></th>
              </tr>
            </thead>
										
            <tbody>
              <?php
              $user_read = $db->select($mx_server_sql);
              $count4 = mysqli_num_rows($user_read);
              if($count4 > 0){
						$z = 0;
                while ($row = $user_read->fetch_assoc()) {
                  $z++; ?>
					  <tr data-target="<?php echo $row['id'] ;?>">
						<td scope="row"><?php echo $z ;?></td>
						<td id="mx_server>" class="table-plus edit_text"><?php echo $row['mx_server'] ;?></td>
						<td id="reason" class="edit_text"><?php echo $row['reason'] ;?></td>
                <td>
							<a class="save" title="<?php _e('Save');?>"><i class="icon-copy dw dw-add"></i></a>
                            <a class="edit" title="<?php _e('Edit');?>"><i class="icon-copy dw dw-edit-1"></i></a>
                            <a class="delete" title="<?php _e('Delete');?>"><i class="icon-copy dw dw-delete-3"></i></a>
                   </td>
              </tr>
            <?php }} ?>

            </tbody>

          </table>
			</div>
						
		</div>

	</div>
</div>

<?php } // MX Server Filter Setting?>
  
  </div>
 </div>   

<?php if(isset($_SESSION['auth_log']) && $_SESSION['auth_log'] == true){ ?>
<!-- License Setting -->
<div id="license_details" class="mt-5">
	<div class="row">
		<div class="col-md-6">
			<div class="pd-20 card-box mb-30">
			  <?php if(isset($_SESSION['action']) && isset($_SESSION['action_cat']) && $_SESSION['action_cat'] == 'licanse_status'){ ?>
				<span class="text-<?php echo $_SESSION['action'] ? 'danger' : 'success' ?>"><?php echo isset($_SESSION['action_message']) ? $_SESSION['action_message'] : '' ;?></span>
			  <?php } ?>
			  <?php if(isset($_SESSION['lic_err']) &&  $_SESSION['lic_err'] == true){ ?>
				<div class="alert bg-danger text-light text-center"><?php _e('License Deactivate');?></div>
			  <?php }else{ ?>
			  
			  <div class="license_details">
			  <h3><?php _e('License Details');?></h3>
			  
				<h6><?php _e('License Type');?>:</h6>
				<p><?php echo $lic_type;?></p>
				
				<h6><?php _e('License Exp. Time');?>:</h6>
				<p><?php echo $lic_exp;?></p>
				
				<h6><?php _e('Support Duration');?>:</h6>
				<p><?php echo $lic_support;?></p>
				
			  </div>
			  
				<div class="alert bg-success text-light text-center"><?php _e('License Active');?></div>
			  <?php } ?>
			  <div class="setting-box mt-4">
				<?php
				require_once('../functions/'.$enc_dec);
				$license = file_get_contents('../config/.lic');
				$license_code =  encrypt($license);
				?>
				<form action="<?php echo $lic_updt;?>" method="post">
				  <?php if(isset($_SESSION['lic_err']) &&  $_SESSION['lic_err'] == true){ ?>
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('License code');?></label>
					  <div class="col-sm-8">
						<input type="text" required name="license_key" class="form-control" value="<?php echo $license_code;?>" placeholder="<?php _e('enter your purches/license code');?>">
					  </div>
					</div>
					<div class="form-group row">
					  <label class="col-sm-4 col-form-label"><?php _e('Your email');?></label>
					  <div class="col-sm-8">
						<input type="email" required name="email" class="form-control" value="" placeholder="<?php _e('enter your email');?>">
					  </div>
					</div>
					<div class="form-group pb-20">
					  <div class="float-right">
						<button type="submit" name="active_licanse" class="btn btn-success"><?php _e('Active');?></button>
					  </div>
					</div>
				  <?php }else{ ?>
					<div class="form-group pb-20">
					  <div class="float-right">
						<button type="submit" name="inactive_licanse" class="btn btn-danger"><?php _e('Deactivate');?></button>
					  </div>
					</div>
				  <?php } ?>
				</form>
			  </div> <!-- /.setting-box -->

			</div>    

		</div>
	</div>
</div>
<!-- / License Setting -->
<?php } ?>
</div> <!-- Settings Area -->
<?php include '../templates/backend/members/footer.php'; ?>
<?php unset($_SESSION['action'])?>
<?php unset($_SESSION['action_message'])?>
<?php unset($_SESSION['action_cat'])?>